document.getElementById("contactButton").addEventListener("click", () => {
    window.open("https://simple-tos.staging.dankdmitron.dev/#contact", "_blank");
});

document.getElementById("websiteButton").addEventListener("click", () => {
    window.open("https://simple-tos.staging.dankdmitron.dev/", "_blank");
});

document.getElementById("scanButton").addEventListener("click", async() => {
    const [tab] = await chrome.tabs.query({ active: true, currentWindow: true });
    await chrome.scripting.executeScript({
        target: { tabId: tab.id },
        files: ['js/content-script.js']
    });
    window.close();
});

document.getElementById("settingsButton").addEventListener("click", () => {
    bootstrap.Modal.getOrCreateInstance(document.getElementById("settingsModal")).show();
});

document.querySelectorAll(".settings-option").forEach((element) => {
    element.addEventListener("change", async() => {
        let settings = (await chrome.storage.sync.get("settings")).settings;
        if (!settings) settings = {};
        settings[element.id] = element.checked;
        await chrome.storage.sync.set({"settings": settings});
    });
});

let updateSettings = async function() {
    let settings = (await chrome.storage.sync.get("settings")).settings;
    if (!settings) return;
    for (let id of Object.keys(settings)) {
        let element = document.getElementById(id);
        if (element) element.checked = settings[id];
    }
}

updateSettings().then()