(async() => {
    console.log("Sending HTML to server...");

    let details = {
        document: document.body.innerHTML
    }

    let formBody = [];
    for (let property in details) {
        let encodedKey = encodeURIComponent(property);
        let encodedValue = encodeURIComponent(details[property]);
        formBody.push(encodedKey + "=" + encodedValue);
    }
    formBody = formBody.join("&");

    let response = await fetch("https://simple-tos.staging.dankdmitron.dev/shorten", {
        method: "POST",
        headers: {
            "Content-Type": "application/x-www-form-urlencoded;charset=UTF-8"
        },
        body: formBody
    });

    console.log(response);

    if (response.ok) {
        document.body.innerHTML = await response.text();
    } else {
        alert(`Failed to shorten document text: Server returned error code ${response.status}`);
    }

})();